$(document).ready(function() {

  setInterval(function () {
    var currentTime = new Date();
    var date = currentTime.toLocaleDateString(["ban", "id"], {
      year: "numeric",
      month: "2-digit",
      day: "2-digit",
    });
    var hours = currentTime.getHours();
    var minutes = currentTime.getMinutes();
    var seconds = currentTime.getSeconds();

    // Add leading zeros
    hours = (hours < 10 ? "0" : "") + hours;
    minutes = (minutes < 10 ? "0" : "") + minutes;
    seconds = (seconds < 10 ? "0" : "") + seconds;

    // Compose the string for display
    var currentTimeString = hours + ":" + minutes + ":" + seconds;
    $("#timer").html(
      date + " " + currentTimeString + " (GMT+" + Math.abs(currentTime.getTimezoneOffset() / 60) + ")"
    );
  }, 1000);

  var url = window.location,
      urlPath = window.location.pathname,
      imgDomain = entityData.imageDomain || '';

  $(".header-menu ul li a, .bottom-nav a").each(function(){
    if($(this).prop("href")==url){
      $(this).closest('li').addClass("active");
    }
  });

  if(urlPath == '/'){
    $(".header-menu ul li:first-child a").closest('li').addClass("active");
  }

  // Menu 2
  $('.menu-2').find(`a[href$="${urlPath.split('/').pop() || "index"}"]`).parent().addClass('active');

  $('body').append('<div class="modal modal-notification"> <div class="modal__box"> <div class="modal__content modal-bb"> <div class="notif-header"> <h2 class="notif-header__title">Notifikasi</h2> <div class="notif-header__close modal-close"><img src="' + imgDomain +'/common/assets/images/icon/close.svg"></div> </div> <div class="notif-body"> <div class="s-a2"></div> </div> </div> </div> </div>')

  $(document).on('click', '.s-check', function(){
    alertMsg('Silahkan login atau mendaftar untuk masuk kedalam permainan.');
    return false;
  });

  if(entityData.runningText.length > 0){
    if($('.s-a').length){
      $('.s-a').append('<marquee scrolldelay="150" behavior="scroll" onmouseover="this.stop();" onmouseout="this.start();" direction="left">'+entityData.runningText+'</marquee>');
    }
    if($('.s-a2').length){
      $('.s-a2').append(entityData.runningText);
    }
  }

  if($('.s-sidebar').length){

    var downloadURL = "/mobile"

    if(typeof globalObj != "undefined"){
      if(globalObj.login){
        downloadURL = "/secure/mobile"
      }
    }

    $('.s-sidebar').append('<div class="sidebar__left"><a href="'+downloadURL+'"><picture><source srcset="/assets/img/download.webp" type="image/webp"><img src="/assets/img/download.png" width="62" height="241" loading="lazy" alt="download"></picture></a></div><div class="sidebar__right s-cs"><a href="#" class="contact"><picture><source srcset="/assets/img/contact.webp" type="image/webp"><img src="/assets/img/contact.png" width="61" height="241" loading="lazy" alt="contact"></picture></a><ul></ul></div>');
  }

  $(document).on('click', '.g8mmenu', function(){
    $('body').toggleClass('swmenu')
    return false;
  });

  $(document).on('click', '.g8mmenu-close', function(){
    $('body').removeClass('swmenu')
    return false;
  });

  $(document).on('click', '.g8pop-ann', function(){
    // If no message count
    if (!$(this).find('.notif-info').hasClass('notanim')) {
      $(".modal").fadeOut();
      $(".modal-notification").fadeIn();
      $("body").css("overflow-y", "hidden");
      return false;
    }
  });

  $(document).on('click', '.modal-close', function(){
    $(".modal").fadeOut();
    $("body").removeAttr("style");
    return false;
  });

  $(document).mouseup(function (e){
    if($('.modal').is(":visible")){
      var container = $('.modal-bb');

      if (!container.is(e.target) && container.has(e.target).length === 0){
        $(".modal").fadeOut();
        $("body").removeAttr("style");
      }
    }
  });

  $(document).on('click', '.seo-top', function(){
    if ($(this).next().is(":visible")) {
      $(this).find('.arrow').removeClass('aa')
      $(this).next().slideUp("2000");
    } else {
      $(this).find('.arrow').addClass('aa')
      $(this).next().slideDown("2000");
    }
    return false;
  });

  $(document).on('click', '.adt', function(){
    if ($(this).next().is(":visible")) {
      $(this).next().slideUp("2000");
    } else {
      $(this).next().slideDown("2000");
    }
    return false;
  });

  $(document).on('click', '.adt2', function(){
    if ($(this).next().is(":visible")) {
      $(this).find('.arrow').removeClass('aa')
      $(this).next().slideUp("2000");
    } else {
      $(this).find('.arrow').addClass('aa')
      $(this).next().slideDown("2000");
    }
    return false;
  });

  $(document).on('click', '.showDL', function(){
    var dd = $(this).attr('dd');
    $('.dl-bb').hide()
    if($(this).hasClass('active')){
      $(this).removeClass('active')
      $('.dl-bb').show()
    } else {
      $('.showDL').removeClass('active');
      $(this).addClass('active');
      $('.dl-bb.da-'+dd).show();
    }
    return false;
  });

  if($('.g8-banner').length){

    ajaxCaller('get', '/func/cms/getBannerList', '', function(res){

      if(typeof firstRowBanners == 'undefined'){ firstRowBanners = [] }
      if(typeof sBan == 'undefined'){ sBan = [] }

      if($('.g8-banner-d').length){
        $('.g8-banner-d').empty().append('\
          <div class="swiper-container g8b-d">\
            <div class="swiper-wrapper s-slides"></div>\
            <div class="swiper-button-next"></div><div class="swiper-button-prev"></div>\
            <div class="swiper-pagination"></div>\
          </div>\
        ');
      }

      if($('.g8-banner-m').length){
        $('.g8-banner-m').empty().append('\
          <div class="swiper-container g8b-m">\
            <div class="swiper-wrapper s-slides"></div>\
            <div class="swiper-button-next"></div><div class="swiper-button-prev"></div>\
          </div>\
        ');
      }

      if(res[1].length){
        var sBanOP = [];
        $.each(res[1], function(i, item) {
          sBanOP.push({"url":item[0], "link":item[3], "type":"1", "urlmob":item[1], "title":item[2], "tournament":item[4], "opener":item[5], "reqLogin": item[6]})
        });
        sBan = sBanOP.concat(sBan);
      }

      sBan = firstRowBanners.concat(sBan);

      let preloadItem = sBan[0];

      if (preloadItem) {
        $('head').append(`
          <link rel="preload" fetchpriority="high" as="image" href="${preloadItem['type'] == '2' ? `${imgDomain}/common/images/tnm/${preloadItem['url']}1800x600.webp`: `${imgDomain}${preloadItem['url']}&v=webp`}" type="image/webp"></link>
          <link rel="preload" fetchpriority="high" as="image" href="${preloadItem['type'] == '2' ? `${imgDomain}/common/images/tnm/${preloadItem['url']}640x300.webp`: `${imgDomain}${preloadItem['url']}&v=webp`}" type="image/webp"></link>
        `);
      }

      $.each(sBan, function(i, item) {

        var sBanActive = '', sBanTarget = '', sBanIMGTemp, sBanMobIMGTemp, mobView = $('.g8-banner-m').is(':visible') ? '' : ' loading="lazy"', deskView = $('.g8-banner-d').is(':visible') ? '' : ' loading="lazy"',
          sBanIMG = '<picture><source srcset="'+imgDomain+item['url']+'&v=webp" type="image/webp"><img src="'+imgDomain+item['url']+'" alt="'+item['title']+'" width="1800" height="600"'+(i == 0 ? deskView : ' loading="lazy"')+'></picture>',
          sBanMobIMG = '<picture><source srcset="'+imgDomain+item['urlmob']+'&v=webp" type="image/webp"><img src="'+imgDomain+item['urlmob']+'" alt="'+item['title']+'" width="640" height="300"'+(i == 0 ? mobView : ' loading="lazy"')+'></picture>';

        if(i == 0){ sBanActive = 'active' }

        if(item['type'] == '2'){
          sBanIMG = '<picture><source srcset="'+imgDomain+'/common/images/tnm/'+item['url']+'1800x600.webp" type="image/webp"><img src="'+imgDomain+'/common/images/tnm/'+item['url']+'1800x600.jpg" alt="'+item['title']+'" width="1800" height="600"'+(i == 0 ? deskView : ' loading="lazy"')+'></picture>';
          sBanMobIMG = '<picture><source srcset="'+imgDomain+'/common/images/tnm/'+item['urlmob']+'640x300.webp" type="image/webp"><img src="'+imgDomain+'/common/images/tnm/'+item['urlmob']+'640x300.jpg" alt="'+item['title']+'" width="640" height="300"'+(i == 0 ? mobView : ' loading="lazy"')+'></picture>';
        }

        if(item['opener'] == '1'){
          sBanTarget = 'target="_blank"'
        }

        if(item['link']){
          if(item['link'] != '#'){
            sBanIMGTemp = '<a href="'+item['link']+'" '+sBanTarget+' rel="noopener noreferrer nofollow">'+sBanIMG+'</a>';
            sBanMobIMGTemp = '<a href="'+item['link']+'" '+sBanTarget+' rel="noopener noreferrer nofollow">'+sBanMobIMG+'</a>';
          }
        }

        if(!globalObj.login){
          if(item['reqLogin'] == '1'){
            return
          }
        }

        if(sBanIMGTemp){ sBanIMG = sBanIMGTemp }
        if(sBanMobIMGTemp){ sBanMobIMG = sBanMobIMGTemp }

        if($('.g8-banner-d').length){
          $('.g8b-d .s-slides').append('<div class="swiper-slide '+sBanActive+'">'+sBanIMG+'</div>');
        }

        if($('.g8-banner-m').length){
          $('.g8b-m .s-slides').append('<div class="swiper-slide '+sBanActive+'">'+sBanMobIMG+'</div>');
        }

      });

      var mySwiper = new Swiper(".g8-banner .swiper-container", {
          autoplay: { delay: 5000, disableOnInteraction: false },
          loop: true,
          pagination: { el: ".g8-banner .swiper-pagination", clickable: "true" },
          navigation: { nextEl: ".g8-banner .swiper-button-next", prevEl: ".g8-banner .swiper-button-prev" },
      });

    })

  }

  if($('.member-service').length || $('.contact-socials').length) {
    var j = 0, content = "";

    $.each(entityData, function(i, item) {
      if(item.length > 0 && ['facebook', 'instagram', 'line', 'skype', 'sms', 'telegram', 'telephone', 'tiktok', 'youtube', 'twitter', 'wechatId', 'whatsapp'].includes(i)) {
        var scName = i, faName = 'fab fa-'+i, link = 'javascript:void(0)';
        if(i == 'facebook'){ link = 'https://www.facebook.com/'+ item}
        if(i == 'instagram'){ link = 'https://www.instagram.com/'+ item; item='@'+item;}
        if(i == 'line'){ link = 'http://line.me/ti/p/~'+ item}
        if(i == 'skype'){ link = 'skype:'+item+'?chat'}
        if(i == 'sms'){ link = 'sms:'+ item; scName = 'sms'; faName = 'fa fa-comment' }
        if(i == 'telegram'){ link = 'https://t.me/'+ item; item='@'+item;}
        if(i == 'telephone'){ link = 'tel:'+ item; scName = 'phone'; faName = 'fa fa-phone' }
        if(i == 'tiktok'){ link = 'https://www.tiktok.com/@'+ item; item='@'+item;}
        if(i == 'youtube'){ link = 'https://www.youtube.com/'+ item;}
        if(i == 'twitter'){ link = 'https://twitter.com/'+ item; item='@'+item;}
        if(i == 'wechatId'){ link = 'weixin://dl/chat?'+item; scName = 'wechat'; faName = 'fab fa-weixin' }
        if(i == 'whatsapp'){ link = 'https://api.whatsapp.com/send?phone='+item}

        let el = `<a href="${link}" target="_blank" rel="noopener noreferrer nofollow"><i class="${faName}"></i><span>${item}</span></a>`;

        if (j === 5) {
          j = 0;
          $('.member-service .swiper-wrapper').append(`<div class="swiper-slide">${content}</div>`);
          content = '';
        }

        content += el;

        $('.contact-socials').append(el);

        j++;
      }
    });

    // last item
    if (content !== "") {
      $('.member-service .swiper-wrapper').append(`<div class="swiper-slide">${content}</div>`);
    }

    if (typeof Swiper !== 'undefined') {
      new Swiper(".member-service .swiper", {
        slidesPerView: 1,
        spaceBetween: 8,
        speed: 400,
        autoplay: {
            delay: 4000,
            disableOnInteraction: false,
        },
        pagination: {
            el: '.member-service .swiper-pagination',
            clickable: true,
            dynamicBullets: true,
        }
      });
    }
  }

  if($('.s-cs').length){

    var csContact = false;

    if($('.s-cs-contact').length){
      csContact = true
    }

    if(entityData.facebook.length > 0){
      $('.s-cs ul').append('<li><a href="https://www.facebook.com/'+entityData.facebook+'" target="_blank" rel="noopener noreferrer nofollow" aria-label="facebook"><i class="fab fa-facebook-square"></i><span>'+entityData.facebook+'</span></a></li>');
      $('.s-cs2 ul').append('<li><a href="https://www.facebook.com/'+entityData.facebook+'" target="_blank" rel="noopener noreferrer nofollow" aria-label="facebook"><i class="fab fa-facebook-square"></i></a></li>');

      if(csContact){
        $('.s-cs-contact').append('<li><span>Facebook</span><i class="fab fa-facebook-square"></i><a href="https://www.facebook.com/'+entityData.facebook+'" target="_blank" rel="noopener noreferrer nofollow" aria-label="facebook">'+entityData.facebook+'</a></li>');
      }
    }

    if(typeof entityData.instagram != "undefined"){
      if(entityData.instagram.length > 0){
        $('.s-cs ul').append('<li><a href="https://www.instagram.com/'+entityData.instagram+'" target="_blank" rel="noopener noreferrer nofollow" aria-label="instagram"><i class="fab fa-instagram"></i><span>@'+entityData.instagram+'</span></a></li>');
        $('.s-cs2 ul').append('<li><a href="https://www.instagram.com/'+entityData.instagram+'" target="_blank" rel="noopener noreferrer nofollow" aria-label="instagram"><i class="fab fa-instagram"></i></a></li>');

        if(csContact){
          $('.s-cs-contact').append('<li><span>Instagram</span><i class="fab fa-instagram"></i><a href="https://www.instagram.com/'+entityData.instagram+'" target="_blank" rel="noopener noreferrer nofollow" aria-label="instagram">@'+entityData.instagram+'</a></li>');
        }
      }
    }

    if(entityData.line.length > 0){
      $('.s-cs ul').append('<li><a href="http://line.me/ti/p/~'+entityData.line+'" target="_blank" rel="noopener noreferrer nofollow" aria-label="line"><i class="fab fa-line"></i><span>'+entityData.line+'</span></a></li>');
      $('.s-cs2 ul').append('<li><a href="http://line.me/ti/p/~'+entityData.line+'" target="_blank" rel="noopener noreferrer nofollow" aria-label="line"><i class="fab fa-line"></i></a></li>');

      if(csContact){
        $('.s-cs-contact').append('<li><span>Line</span><i class="fab fa-line"></i><a href="http://line.me/ti/p/~'+entityData.line+'" target="_blank" rel="noopener noreferrer nofollow" aria-label="line">'+entityData.line+'</a></li>');
      }
    }

    if(entityData.skype.length > 0){
      $('.s-cs ul').append('<li><a href="skype:'+entityData.skype+'?chat" aria-label="skype"><i class="fab fa-skype"></i><span>'+entityData.skype+'</span></a></li>');
      $('.s-cs2 ul').append('<li><a href="skype:'+entityData.skype+'?chat" aria-label="skype"><i class="fab fa-skype"></i></a></li>');

      if(csContact){
        $('.s-cs-contact').append('<li><span>Skype</span><i class="fab fa-skype"></i><a href="skype:'+entityData.skype+'?chat" aria-label="skype">'+entityData.skype+'</a></li>');
      }
    }

    if(typeof entityData.sms != "undefined"){
      if(entityData.sms.length > 0){
        $('.s-cs ul').append('<li><a href="sms:'+entityData.sms+'" aria-label="sms"><i class="fa fa-comment"></i><span>'+entityData.sms+'</span></a></li>');
        $('.s-cs2 ul').append('<li><a href="sms:'+entityData.sms+'" aria-label="sms"><i class="fa fa-comment"></i></a></li>');

        if(csContact){
          $('.s-cs-contact').append('<li><span>SMS</span><i class="fa fa-comment"></i><a href="sms:'+entityData.sms+'" aria-label="sms">'+entityData.sms+'</a></li>');
        }
      }
    }

    if(typeof entityData.telegram != "undefined"){
      if(entityData.telegram.length > 0){
        $('.s-cs ul').append('<li><a href="https://t.me/'+entityData.telegram+'" target="_blank" rel="noopener noreferrer nofollow" aria-label="telegram"><i class="fab fa-telegram"></i><span>@'+entityData.telegram+'</span></a></li>');
        $('.s-cs2 ul').append('<li><a href="https://t.me/'+entityData.telegram+'" target="_blank" rel="noopener noreferrer nofollow" aria-label="telegram"><i class="fab fa-telegram"></i></a></li>');

        if(csContact){
          $('.s-cs-contact').append('<li><span>Telegram</span><i class="fab fa-telegram"></i><a href="https://t.me/'+entityData.telegram+'" target="_blank" rel="noopener noreferrer nofollow" aria-label="telegram">@'+entityData.telegram+'</a></li>');
        }
      }
    }

    if(entityData.telephone.length > 0){
      $('.s-cs ul').append('<li><a href="tel:'+entityData.telephone+'" aria-label="telephone"><i class="fa fa-phone"></i><span>'+entityData.telephone+'</span></a></li>');
      $('.s-cs2 ul').append('<li><a href="tel:'+entityData.telephone+'" aria-label="telephone"><i class="fa fa-phone"></i></a></li>');

      if(csContact){
        $('.s-cs-contact').append('<li><span>Phone</span><i class="fa fa-phone"></i><a href="tel:'+entityData.telephone+'" aria-label="telephone">'+entityData.telephone+'</a></li>');
      }
    }

    if(entityData.tiktok.length > 0){
      $('.s-cs ul').append('<li><a href="https://tiktok.com/@'+entityData.tiktok+'" target="_blank" rel="noopener noreferrer nofollow" aria-label="tiktok"><i class="fab fa-tiktok"></i><span>@'+entityData.tiktok+'</span></a></li>');
      $('.s-cs2 ul').append('<li><a href="https://tiktok.com/@'+entityData.tiktok+'" target="_blank" rel="noopener noreferrer nofollow" aria-label="tiktok"><i class="fab fa-tiktok"></i></a></li>');

      if(csContact){
        $('.s-cs-contact').append('<li><span>Tiktok</span><i class="fab fa-tiktok"></i><a href="https://tiktok.com/@'+entityData.tiktok+'" target="_blank" rel="noopener noreferrer nofollow" aria-label="tiktok">@'+entityData.tiktok+'</a></li>');
      }
    }

    if(entityData.youtube.length > 0){
      $('.s-cs ul').append('<li><a href="https://youtube.com/'+entityData.youtube+'" target="_blank" rel="noopener noreferrer nofollow" aria-label="youtube"><i class="fab fa-youtube"></i><span>'+entityData.youtube+'</span></a></li>');
      $('.s-cs2 ul').append('<li><a href="https://youtube.com/'+entityData.youtube+'" target="_blank" rel="noopener noreferrer nofollow" aria-label="youtube"><i class="fab fa-youtube"></i></a></li>');

      if(csContact){
        $('.s-cs-contact').append('<li><span>Youtube</span><i class="fab fa-youtube"></i><a href="https://youtube.com/'+entityData.youtube+'" target="_blank" rel="noopener noreferrer nofollow" aria-label="youtube">'+entityData.youtube+'</a></li>');
      }
    }

    if(entityData.twitter.length > 0){
      $('.s-cs ul').append('<li><a href="https://twitter.com/'+entityData.twitter+'" target="_blank" rel="noopener noreferrer nofollow" aria-label="twitter"><i class="fab fa-twitter"></i><span>@'+entityData.twitter+'</span></a></li>');
      $('.s-cs2 ul').append('<li><a href="https://twitter.com/'+entityData.twitter+'" target="_blank" rel="noopener noreferrer nofollow" aria-label="twitter"><i class="fab fa-twitter"></i></a></li>');

      if(csContact){
        $('.s-cs-contact').append('<li><span>Twitter</span><i class="fab fa-twitter"></i><a href="https://twitter.com/'+entityData.twitter+'" target="_blank" rel="noopener noreferrer nofollow" aria-label="twitter">@'+entityData.twitter+'</a></li>');
      }
    }

    if(entityData.wechatId.length > 0){
      $('.s-cs ul').append('<li><a href="weixin://dl/chat?'+entityData.wechatId+'" aria-label="wechat"><i class="fab fa-weixin"></i><span>'+entityData.wechatId+'</span></a></li>');
      $('.s-cs2 ul').append('<li><a href="weixin://dl/chat?'+entityData.wechatId+'" aria-label="wechat"><i class="fab fa-weixin"></i></a></li>');

      if(csContact){
        $('.s-cs-contact').append('<li><span>WeChat</span><i class="fab fa-weixin"></i><a href="weixin://dl/chat?'+entityData.wechatId+'" aria-label="wechat">'+entityData.wechatId+'</a></li>');
      }
    }

    if(typeof entityData.whatsapp != "undefined"){
      if(entityData.whatsapp.length > 0){
        $('.s-cs ul').append('<li><a href="https://api.whatsapp.com/send?phone='+entityData.whatsapp+'" target="_blank" rel="noopener noreferrer nofollow" aria-label="whatsapp"><i class="fab fa-whatsapp"></i><span>'+entityData.whatsapp+'</span></a></li>');
        $('.s-cs2 ul').append('<li><a href="https://api.whatsapp.com/send?phone='+entityData.whatsapp+'" target="_blank" rel="noopener noreferrer nofollow" aria-label="whatsapp"><i class="fab fa-whatsapp"></i></a></li>');

        if(csContact){
          $('.s-cs-contact').append('<li><span>Whatsapp</span><i class="fab fa-whatsapp"></i><a href="https://api.whatsapp.com/send?phone='+entityData.whatsapp+'" target="_blank" rel="noopener noreferrer nofollow" aria-label="whatsapp">'+entityData.whatsapp+'</a></li>');
        }
      }
    }

    if(entityData.google.length > 0){
      $('.s-cs ul').append('<li><a href="javascript:viod(0)" aria-label="'+entityData.google+'"><i class="fab fa-google"></i><span>'+entityData.google+'</span></a></li>');
      $('.s-cs2 ul').append('<li><a href="javascript:viod(0)" aria-label="'+entityData.google+'"><i class="fab fa-google"></i></a></li>');

      if(csContact){
        $('.s-cs-contact').append('<li><span>Google</span><i class="fab fa-google"></i><span class="bts">'+entityData.google+'</span></li>');
      }
    }

    if(entityData.yahoo.length > 0){
      $('.s-cs ul').append('<li><a href="javascript:viod(0)" aria-label="'+entityData.yahoo+'"><i class="fab fa-yahoo"></i><span>'+entityData.yahoo+'</span></a></li>');
      $('.s-cs2 ul').append('<li><a href="javascript:viod(0)" aria-label="'+entityData.yahoo+'"><i class="fab fa-yahoo"></i></a></li>');

      if(csContact){
        $('.s-cs-contact').append('<li><span>Yahoo</span><i class="fab fa-yahoo"></i><span class="bts">'+entityData.yahoo+'</span></li>');
      }
    }
  }

  if (typeof webapps === 'object') {
    let apkpath = $('a[data-apkpath]'), pageName = location.pathname.split('/').pop();

    apkpath.attr('href', webapps.link || apkDownloadHost + apkpath.data('apkpath')).attr('target', '_blank');

    $('.g8app-mob .cl img').attr('src', '/assets/custom/img/' + webapps.logo);
    $('.g8app-mob h3').text(webapps.name);

    var ua = getURLParameter('ua');
    if(ua == 'apps'){
      setCookie('webapps', ua);
      window.history.replaceState(null, null, window.location.pathname);
    }

    if(!getCookie('webapps') && ['', 'index', 'index.html', 'home', 'home.html'].includes(pageName)) {
      $('.g8app-mob').show();
      $('#showM').addClass('wt');
    }

    $(document).on('click', '.g8app-mob-close', function(){
      $('.g8app-mob').hide()
      $('#showM').removeClass('wt');
      return false;
    });
  }

  // wa icon
  $('body').append(`<a href="${entityData.whatsapp ? 'https://api.whatsapp.com/send?phone=' + entityData.whatsapp : '#'}" target="_blank" rel="noopener noreferrer" class="wa-icon"><img src="${imgDomain}/common/assets/images/whatsapp.png" width="100" height="100" alt="wa icon"></a>`);

  $('.menu .games').click(function() {
    $(this).find('.all-games').slideToggle(300);
  });

  if ($('#showD .seo').children().length === 0 && $('#showD .seo').text().trim().length === 0) {
    $('.seo').addClass('hide');
  }
  // Copyright year
  $('.box-copyright .year').text(new Date().getFullYear());

  // Close popup overlay or close by click cross on #popup_title before content
  $(document).on('click', '#popup_overlay:not(.no-close), #popup_title', function() {
    $.alerts._hide();
  });
});

async function tracking(form, arg1, arg2, callback) {
    if (!globalObj.isLaunchEvent || typeof webTracker == 'undefined') {
        if (callback) callback();
        return;
    }

    const track = await webTracker.trackAction(arg1, arg2);

    let inp = $(form).find('textarea[name="eventData"]');

    if (inp.length) {
        inp.val(track);
    } else {
        $(form).append(`<textarea name="eventData" style="display:none;">${track}</textarea>`);
    }

    if (callback) callback();
}

function getURLParameter(name) {
  return decodeURIComponent((new RegExp('[?|&]' + name + '=' + '([^&;]+?)(&|#|;|$)').exec(location.search) || [null, ''])[1].replace(/\+/g, '%20')) || null;
}

function today(){
  var today = new Date();
  var dd = String(today.getDate()).padStart(2, '0');
  var mm = String(today.getMonth() + 1).padStart(2, '0'); //January is 0!
  var yyyy = today.getFullYear();

  today = yyyy+mm+dd;
  return today
}

function randomInt(min, max) {
  return Math.floor(Math.random() * (max - min + 1) + min);
}

if($('.jackpotNumber').length){
  var cnt = 16800000000;
  var disp = $('.jackpotNumber');

  setInterval(countup, 50);

  function countup() {
    var cnt_str = addCommas(cnt);
    disp.html(cnt_str);
    cnt += randomInt(1, 50);
  }

  function addCommas(nStr){
    nStr += '';
    x = nStr.split('.');
    x1 = x[0];
    x2 = x.length > 1 ? '.' + x[1] : '';
    var rgx = /(\d+)(\d{3})/;
    while (rgx.test(x1)) {
      x1 = x1.replace(rgx, '$1' + ',' + '$2');
    }
    return x1 + x2;
  }

}

// Developer mode
window.onresize = function(event) {
  if (window.outerWidth >= 769 && !$('link.desktop').hasClass('loaded') && $('link.desktop').attr('rel') == 'preload') {
    $('link.desktop').attr('rel', 'stylesheet');
  }
  if (window.outerWidth <= 768 && !$('link.mobile').hasClass('loaded') && $('link.mobile').attr('rel') == 'preload') {
    $('link.mobile').attr('rel', 'stylesheet');
  }
};
