$(document).ready(function() {

  if(typeof globalObj != "undefined"){
    if(globalObj.login){
      window.location = "/secure/home";
    }
  }

  var logo = $('.header-mdl__logo').html();

  $('body').append('\
    <div class="modal modal-forgot">\
      <div class="modal-forgot__dialog">\
      \
        <div class="modal-content modal-bb">\
          <div class="modal-forgot__dialog-header">\
            <div class="forgot-title">Lupa Login</div>\
            <div class="forgot-close modal-close"><i class="fa fa-times"></i></div>\
          </div>\
          \
          <div class="modal-forgot__dialog-body">\
            \
            <div class="img-container">'+ logo +'</div>\
            \
            <form id="ajax-form-pwd" action="/func/account/forget" method="post" novalidate="novalidate">\
              <div class="form-container">\
                \
                <div class="form-group">\
                  <input type="text" class="form-control required" name="username" maxlength="12" minlength="6" placeholder="Username">\
                  <div class="icon"><i class="fas fa-user"></i></div>\
                </div>\
                \
                <div class="form-group">\
                  <input type="text" class="form-control required email" name="email" maxlength="255" placeholder="Email">\
                  <div class="icon"><i class="fas fa-envelope"></i></div>\
                </div>\
                <div class="form-group">\
                  <input type="text" class="form-control required number" name="mobile" maxlength="15" minlength="7" placeholder="Contact Number">\
                  <div class="icon"><i class="fa fa-phone"></i></div>\
                </div>\
                <button type="submit" class="button button--submit">Submit</button>\
              </div>\
            </form>\
            \
          </div>\
          \
        </div>\
        \
      </div>\
    </div>\
    \
    <div class="modal modal-login">\
      <div class="modal-login__dialog">\
        \
        <div class="modal-content modal-bb">\
          <div class="modal-login__dialog-header">\
            <div class="header-title">Login</div>\
            <div class="header-close modal-close"><i class="fa fa-times"></i></div>\
          </div>\
          \
          <div class="modal-login__dialog-body">\
            \
            <div class="img-container">'+ logo +'</div>\
            \
            <form id="login-form-2" action="/j_spring_security_check" method="post" novalidate="novalidate">\
              <div class="form-container">\
              \
                <div class="form-input">\
                  <div class="form-group">\
                    <input type="text" placeholder="Username" name="j_username" class="form-control required">\
                  </div>\
                  <div class="form-group">\
                    <input type="password" placeholder="Password" id="j_password" name="j_password" class="form-control required">\
                  </div>\
                </div>\
                <button type="submit" class="button button--register">Login</button>\
                \
                <div class="text-center">\
                  <a href="#" class="button-forget g8pop-forgot">Lupa Rincian Masuk?</a>\
                  <a href="#" class="button button2 g8pop-signup">Daftar</a>\
                </div>\
                \
              </div>\
            </form>\
            \
          </div>\
          \
        </div>\
        \
      </div>\
    </div>\
  ');

  if(getURLParameter('v')){
    var paramMSG = 'messages.login'+getURLParameter('v');
    jAlert(eval(paramMSG));
    window.history.replaceState(null, null, window.location.pathname);
  } else if (window.location.hash == '#log') {
    $('.modal-login').fadeIn();
  } else if (window.location.hash == '#fgp') {
    $('.modal-forgot').fadeIn();
  } else if(typeof entityData.beforePopupText != "undefined"){
    if(entityData.beforePopupText.length > 0){
      var urlPath = window.location.pathname;
      if(urlPath == '/' || urlPath == '/index' ){
        jAlert(entityData.beforePopupText, '', '');
        $('#popup_content').addClass('home-popup');
      }
    }
  }

  $(document).on('click', '.g8pop-signup', function(){
    window.location.href = '/register'
  });

  $(document).on('click', '.g8pop-forgot', function(){
    $(".modal").fadeOut();
    $(".modal-forgot").fadeIn();
    $("body").css("overflow-y", "hidden");
    return false;
  });

  $(document).on('click', '.g8pop-login', function(){
    $(".modal").fadeOut();
    $(".modal-login").fadeIn();
    $("body").css("overflow-y", "hidden");
    return false;
  });

  if(typeof globalObj != "undefined"){
    if(globalObj.isRegisterFormReferral) {
      $('.g8-refid').show();

      if (getCookie("rcode").length > 0) {
        $('.g8-rcode').attr('readonly', 'readonly').css({'background-color':'#e5e5e5'});
      }
    }

    if(globalObj.isRegBank === false) {
      $('.regbank label span').remove(); // required mark
      $('.regbank .required').removeClass('required'); // required mark
    }

    if(globalObj.isRegMobile === false) {
      $('input[name="mobile"]').removeClass('required').closest('.form-group').find('label span').remove(); // required mark & required validation
    }

    if(globalObj.isRegEmail === false) {
      $('input[name="email"]').removeClass('required').closest('.form-group').find('label span').remove(); // required mark & required validation
    }
  }

  // Login form desktop
  $('#login-form').submit(function(e) {
    e.preventDefault();
  }).validate({
    errorPlacement: function(error, element) {
    },
    invalidHandler: function(form, validator) {
      if($.fn.effect) {
        $("#login-form").effect("shake", {distance: 6, times: 2}, 35);
      }
    },
    submitHandler: function(form) {
      tracking(form, 'Login', 'login_', function() {
        form.submit();
      });
    }
  });

  // Login form mobile
  $('#login-form-2').submit(function(e) {
    e.preventDefault();
  }).validate({
    errorPlacement: function(error, element) {
    },
    invalidHandler: function(form, validator) {
      if($.fn.effect) {
        $("#login-form-2").effect("shake", {distance: 6, times: 2}, 35);
      }
    },
    submitHandler: function(form) {
      tracking(form, 'Login', 'login_', function() {
        form.submit();
      });
    }
  });

  // Register form desktop
  $('#ajax-form-join-special').submit(function(e) {
    e.preventDefault();
  }).validate({
    submitHandler: function(form) {

      var flag = false;
      if(typeof $(form).data('flag') != "undefined"){
        flag = $(form).data('flag');
      }

      if($('#regbank-check').prop("checked") == true){
        $('#regbank-accno').val($('#regbank-phone').val());
        $('#regbank-accname').val($('#regbank-username').val());
      }

      $(form).attr('action', '/func/account/register');

      tracking(form, 'CompleteRegistration', 'reg_', function() {
        submitHandler(form, flag);
      });
    }
  });

  // Register form mobile
  $('#ajax-form-join-mob').submit(function(e) {
    e.preventDefault();
  }).validate({
    submitHandler: function(form) {

      var flag = false;
      if(typeof $(form).data('flag') != "undefined"){
        flag = $(form).data('flag');
      }

      if($('#regbank-check-mob').prop("checked") == true){
        $('#regbank-accno-mob').val($('#regbank-phone-mob').val());
        $('#regbank-accname-mob').val($('#regbank-username-mob').val());
      }

      $(form).attr('action', '/func/account/register');

      tracking(form, 'CompleteRegistration', 'reg_', function() {
        submitHandler(form, flag);
      });
    }
  });

  ajaxCaller('get', '/func/common/getBank', '', function(res){
    for ( var i = 0; i < res[1].length; i++) {
      var data = res[1][i];
      var bankname = data[1];
      bankname = bankname.replace(/\s+/g, '').toLowerCase();
      $('.bank-getbank').append('<option value="'+data[0]+'" dd="'+bankname+'">'+data[1]+'</option>');
    }
  });

  $(document).on('change', '.bank-getbank', function(){
      var dd = $(this).find('option:selected').attr('dd');

      $('.regbank-info').show();

      $('#regbank-check').prop("checked", false)

      if(dd == 'gopay' || dd == 'ovo' || dd == 'dana'){
        $('.regbank-tickbox').show()
      } else {
        $('.regbank-tickbox').hide()
      }

    });

  $(document).on('click', '#regbank-check', function(){
    if($(this).prop("checked") == true){
      $('.regbank-info').hide()
    } else if($(this).prop("checked") == false){
      $('.regbank-info').show()
    }
  });

  checkRefCookie();

});

function resetLoginForm(formId){
  $(formId).find(":password").val('');
  $(formId).find('.form-control').removeClass('valid');
  $(formId).find('.form-control').removeClass('error');
  $(formId).find('label.error').text("").hide();
}

// function refreshCaptcha(){
//   $(".captcha-img").prop("src", "/stickyImg?"+Math.random());
// }

function checkRefCookie() {
  var value = getCookie("rcode");
  if($('.g8-rcode').length && value.length){
    $('.g8-rcode').val(value).attr('readonly', 'readonly');
  }
}

if (typeof loadMeIfReady != 'undefined') {
  loadMeIfReady();
}
